from pprint import pprint

from django.contrib.auth import authenticate, logout
from django.core.exceptions import MultipleObjectsReturned
from django.core.mail import send_mail
from django.db.models import F, Sum
from django.template.loader import render_to_string
from django.utils import timezone
from rest_framework import status
from rest_framework.authtoken.models import Token
from rest_framework.response import Response
from rest_framework.views import APIView

from apis.serializers.transaction_serializer import TransactionReceiptSerializer, SingleTransactionReceiptSerializer
from transactions.models import Transactions


class LastTwentyTransactionsViewAPI(APIView):
    permission_classes = ()

    def get(self, request):
        try:
            user = request.user
            the_branch = user.staff.branch
        except:
            return Response({
                "code": 200,
                'message': 'failed',
                "details": 'Provide a valid token'
            }, status=200)

        # first get transaction id
        # all_transactions = Transactions.objects.filter(added_by=user.staff).values('receipt').annotate(
        #     total=Sum('reporting_amount')).order_by('receipt').distinct()
        all_transactions = Transactions.objects.filter(added_by=user.staff, receipt__isnull=False, transaction_type='Deposit', branch=the_branch).exclude(receipt='').order_by('-id').values('receipt').distinct()[:10]
        # pprint(list(all_transactions))
        serializer = TransactionReceiptSerializer(all_transactions, many=True, context={'branch': the_branch})
        return Response({
            "code": 200,
            'message': 'success',
            "transactions": serializer.data
        }, status=200)


class GetSingleReceiptViewAPI(APIView):
    permission_classes = ()
    def get(self, request, receipt_number):
        try:
            user = request.user
            the_branch = user.staff.branch
        except:
            return Response({
                "code": 200,
                'message': 'failed',
                "details": 'Provide a valid token'
            }, status=200)
        all_transactions = Transactions.objects.filter(receipt=receipt_number.strip(), branch=the_branch, transaction_type='Deposit').values('receipt')
        if not all_transactions.exists():
            return Response({
                "code": 400,
                'message': 'failed',
                "details": 'Receipt doesnot exist or its not a deposit'
            }, status=400)
        serializer = SingleTransactionReceiptSerializer(all_transactions.first(), context={'branch': the_branch})
        return Response({
            "code": 200,
            'message': 'success',
            "transaction": serializer.data
        }, status=200)



