from django.contrib.auth import authenticate, logout
from django.core.exceptions import MultipleObjectsReturned
from django.core.mail import send_mail
from django.template.loader import render_to_string
from django.utils import timezone
from rest_framework import status
from rest_framework.authtoken.models import Token
from rest_framework.response import Response
from rest_framework.views import APIView

from accounts.models import User, EmailResetCode, Business, Biz_status
from apis.serializers.auth_serializer import UserSerializer, BioDataSerializer, loginSerializer
from apis.utils import expiry
from sacco.models import UserMember
from utils.general import random_with_N_digits



class LoginViewAPI(APIView):
    authentication_classes = ()
    permission_classes = ()

    def post(self, request):
        username = request.data["username"]
        bizz_no = request.data["bizz_no"]
        password = request.data["password"]
        user = authenticate(username=username, password=password)
        try:
            bizz = Business.objects.get(business_number=bizz_no)
        except Business.DoesNotExist:
            bizz = None
        except MultipleObjectsReturned:
            bizz = None
        if bizz and bizz.status == Biz_status.Active:
            if user:
                print('yes')
                membership = UserMember.objects.filter(user=user).first()
                # print(membership.member.branch.business.business_number)
                if membership:
                    if membership.member.branch.business.business_number == bizz.business_number:

                        data = User.objects.get(id=user.id)
                        token, created = Token.objects.get_or_create(user=user)
                        if not created:
                            token.delete()
                            token = Token.objects.create(user=user)

                        return Response(
                            {
                                "code": 1, "token": token.key,
                                "response": "Login successful",
                                "data": UserSerializer(data).data
                             }, status=200
                        )
                    else:
                        return Response({"code": 0, "response": "Member does not belong to business"},
                                        status=status.HTTP_400_BAD_REQUEST)
                else:
                    return Response({"code": 0, "response": "Member does not exist"},
                                    status=status.HTTP_400_BAD_REQUEST)
            return Response({"code": 0, "response": "The Credentials entered does not match any account"}, status=status.HTTP_400_BAD_REQUEST)
        return Response({"code": 0, "response": "The Credentials entered does not match any account"}, status=status.HTTP_400_BAD_REQUEST)


class LogoutView(APIView):
    def post(self, request):
        request.user.auth_token.delete()
        logout(request)
        return Response(status=204)


class ForgotPasswordView(APIView):
    authentication_classes = ()
    permission_classes = ()

    def post(self, request,):
        mymail = request.data.get("email")
        if mymail or mymail != '':
            user = User.objects.filter(email=mymail).first()
            if user is not None:
                email_reset, created = EmailResetCode.objects.get_or_create(user=user)
                if not created:
                    email_reset.code = random_with_N_digits(6)
                    email_reset.generated = timezone.now() + expiry()
                    email_reset.is_used = False
                    email_reset.save()
                    from_email = "accounts@malawibiodiversityportal.mw"
                    to_email = user.email
                    subject = "Reset Password"
                    context = {"fname": user.first_name, "sname": user.last_name, "token": email_reset.code}
                    msg_plain = render_to_string('accounts/emails/email.txt', context)
                    msg_html = render_to_string('accounts/emails/email.html', context)
                    send_mail(subject, msg_plain, from_email, [to_email], html_message=msg_html)
                    return Response({"code": 1, "response": "Reset Code sent to your email"}, status=status.HTTP_200_OK)

        return Response({"code": 0, "response": "Wrong email"}, status=status.HTTP_400_BAD_REQUEST)


class EnterCode(APIView):
    authentication_classes = ()
    permission_classes = ()

    def post(self, request, email):
        code = request.data.get("code")
        if User.objects.filter(email=email).exists():
            if EmailResetCode.objects.filter(code=code, user__email=email).exists():
                user_code = EmailResetCode.objects.filter(code=code, user__email=email).first()
                if timezone.now() <= user_code.generated:
                    if not user_code.is_used:
                        EmailResetCode.objects.filter(id=user_code.id).update(is_used=True)
                        print(user_code.is_used)

                        return Response({"code": 1, "response": "Code successful"}, status=status.HTTP_200_OK)
                    else:
                        return Response({"code": 0, "response": "Code already used"}, status=status.HTTP_400_BAD_REQUEST)
                else:
                    return Response({"code": 0, "response": "Code has expired"}, status=status.HTTP_400_BAD_REQUEST)
            return Response({"code": 0, "response": "Invalid code"}, status=status.HTTP_400_BAD_REQUEST)
        else:
            return Response({"code": 0, "response": "User does not exist"}, status=status.HTTP_400_BAD_REQUEST)


class NewPasswordView(APIView):
    authentication_classes = ()
    permission_classes = ()

    def post(self, request, email=None, code=None):
        if EmailResetCode.objects.filter(code=code, user__email=email).exists():
            this_user = User.objects.filter(email=email).first()
            password1 = request.data['password1']
            password2 = request.data['password2']
            if len(password1) >= 8 and len(password2) >= 8:
                if password1 == password2:
                    this_user.set_password(password1)
                    this_user.save()
                    return Response({'code': 1, 'response': 'Updated Password'},
                                    status=status.HTTP_200_OK)
                else:
                    return Response({'code': 0, 'response': 'Passwords dont match'},
                                    status=status.HTTP_400_BAD_REQUEST)
            else:
                return Response({'code': 0, 'response': 'Passwords should be greater or equal to length of 8'},
                                status=status.HTTP_400_BAD_REQUEST)
        else:
            return Response({'code': 0, 'response': 'Invalid code or email'},
                            status=status.HTTP_400_BAD_REQUEST)


class ChangePasswordAPIView(APIView):

    def post(self, request):
        old_password = request.data['old_password']
        new_password = request.data['new_password']
        new_password1 = request.data['new_password1']

        if not request.user.check_password(old_password):
            return Response({'code': 0, 'response': 'Old Password is wrong'},
                            status=status.HTTP_400_BAD_REQUEST)
        elif new_password1 != new_password:
            return Response({'code': 0, 'response': 'New password and Confirm password dont match'},
                            status=status.HTTP_400_BAD_REQUEST)
        else:
            request.user.set_password(new_password1)
            request.user.save()
            return Response({'code': 1, 'response': 'Successfully updated password'},
                            status=status.HTTP_202_ACCEPTED)



class AppStaffLoginViewAPI(APIView):
    authentication_classes = ()
    permission_classes = ()
    def post(self, request):
        serializer = loginSerializer(data=request.data)
        if not serializer.is_valid(raise_exception=True):
            return Response(serializer.errors, status=400)
        username = serializer.validated_data['username']
        password = serializer.validated_data['password']
        user = authenticate(username=username, password=password)
        if user:
            print('USER EXISTS')
            the_business = user.staff.biodata.business
            if not the_business:
                return Response({"code": 400, "details": 'Business doesnot exist'}, status=400)
            if the_business.status == Biz_status.Active:
                token, created = Token.objects.get_or_create(user=user)
                if not created:
                    token.delete()
                    token = Token.objects.create(user=user)
                print('BAM BAM')
                return Response({
                    "code": 200,
                    'message':'success',
                    'token':token.key,
                    "user": BioDataSerializer(user.staff.biodata).data
                }, status=200)
            else:
                return Response({
                    "code": 400,
                    'message': 'failed',
                    "details": 'Expired license'
                }, status=200)
        else:
            return Response({
                "code": 400,
                'message': 'failed',
                "details": 'Invalid credentials'
            }, status=200)