from django.urls import path, re_path

from apis.views.auth_view import LoginViewAPI, ChangePasswordAPIView, LogoutView, AppStaffLoginViewAPI
from apis.views.core_view import TransactionsAPI, AccountBalanceAPI, SharesViewAPI, ProfileViewAPI, \
    LoansAPI, SavingsAPI, WithdrawsAPIView, TransfersAPIView, RepaymentAPIView, MemberStatementAPI
from apis.views.transaction_view import LastTwentyTransactionsViewAPI, GetSingleReceiptViewAPI

urlpatterns = [
    # auth
    path('login/', LoginViewAPI.as_view()),
    path('change-password/', ChangePasswordAPIView.as_view()),
    path('logout/', LogoutView.as_view()),
    path('profile/', ProfileViewAPI.as_view()),
    path('staff-login/', AppStaffLoginViewAPI.as_view()),

    # core
    path('transactions/', TransactionsAPI.as_view()),
    path('shares/', SharesViewAPI.as_view()),
    path('loans/', LoansAPI.as_view()),
    path('account-balance/', AccountBalanceAPI.as_view()),
    path('deposits/', SavingsAPI.as_view()),
    path('withdraws/', WithdrawsAPIView.as_view()),
    path('transfers/', TransfersAPIView.as_view()),
    path('repayments/', RepaymentAPIView.as_view()),
    path('member-statement/', MemberStatementAPI.as_view()),
    path('last-twenty-transactions/', LastTwentyTransactionsViewAPI.as_view()),
    path('get-single-receipt/<slug:receipt_number>', GetSingleReceiptViewAPI.as_view()),

]