from django.db.models import Sum
from rest_framework import serializers

from sacco.models import MemberAccount, AccountBroker
from transactions.models import Transactions

class TransactionSerializer(serializers.ModelSerializer):
    class Meta:
        model = Transactions
        exclude = ('receipt','reference',)


class TransactionReceiptSerializer(serializers.Serializer):
    receipt = serializers.CharField(read_only=True)
    total_amount = serializers.SerializerMethodField()
    transaction_involved = serializers.SerializerMethodField()
    branch = serializers.IntegerField(read_only=True)
    transaction_date = serializers.SerializerMethodField()
    account_number = serializers.SerializerMethodField()
    account_name = serializers.SerializerMethodField()


    def get_total_amount(self, obj):
        queryset = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch'], transaction_type='Deposit')
        other_charges = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch']).exclude(transaction_type__in=['SMS Charge', 'Deposit'])
        total = queryset.aggregate(Sum('reporting_amount'))
        other_charges = other_charges.aggregate(Sum('reporting_amount'))
        if total['reporting_amount__sum'] is None:
            total = 0
        else:
            total = total['reporting_amount__sum']
        if other_charges['reporting_amount__sum'] is None:
            other_charges = 0
        else:
            other_charges = other_charges['reporting_amount__sum']
        return total - other_charges

    def get_transaction_involved(self, obj):
        queryset = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch']).exclude(transaction_type='SMS Charge')
        serializer_trans = TransactionSerializer(queryset, many=True)
        # print('serializer_trans====',serializer_trans)
        return serializer_trans.data

    def get_transaction_date(self, obj):
        queryset = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch']).first()
        return queryset.tx_date

    def get_account_number(self, obj):
        queryset = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch'], transaction_type='Deposit')
        account_number = ''
        if queryset.exists():
            account_number = queryset.first().account_cr.member.acc_number

        # if queryset.loan is not None:
        #     account_number = queryset.loan.account.acc_number
        # elif queryset.transaction_type == 'Deposit':
        #     account_number = queryset.account_cr.member.acc_number
        # elif queryset.transaction_type == 'Deposit':
        #     account_number = queryset.account_cr.member.acc_number
        return account_number

    def get_account_name(self, obj):
        queryset = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch'], transaction_type='Deposit')
        account_name = ''
        if queryset.exists():
            account_number = queryset.first().account_cr.member.acc_number
            # member_acc = MemberAccount.objects.filter(acc_number=str(account_number))
            member_acc = AccountBroker.objects.filter(the_account__acc_number=str(account_number), business=self.context['branch'].business)

            if member_acc.exists():
                account_name = member_acc.first().the_account.member_names
        return account_name



class SingleTransactionReceiptSerializer(serializers.Serializer):
    receipt = serializers.CharField(read_only=True)
    total_amount = serializers.SerializerMethodField()
    transaction_involved = serializers.SerializerMethodField()
    branch = serializers.IntegerField(read_only=True)
    transaction_date = serializers.SerializerMethodField()
    account_number = serializers.SerializerMethodField()
    account_name = serializers.SerializerMethodField()


    def get_total_amount(self, obj):
        queryset = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch'], transaction_type='Deposit')
        other_charges = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch']).exclude(
            transaction_type__in=['SMS Charge', 'Deposit'])
        total = queryset.aggregate(Sum('reporting_amount'))
        other_charges = other_charges.aggregate(Sum('reporting_amount'))
        if total['reporting_amount__sum'] is None:
            total = 0
        else:
            total = total['reporting_amount__sum']
        if other_charges['reporting_amount__sum'] is None:
            other_charges = 0
        else:
            other_charges = other_charges['reporting_amount__sum']
        return total - other_charges

    def get_transaction_involved(self, obj):
        queryset = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch']).exclude(transaction_type='SMS Charge')
        serializer_trans = TransactionSerializer(queryset, many=True)
        # print('serializer_trans====',serializer_trans)
        return serializer_trans.data

    def get_transaction_date(self, obj):
        queryset = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch']).first()
        return queryset.tx_date

    def get_account_number(self, obj):
        queryset = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch'])
        account_number = ''
        if queryset.exists():
            account_number = queryset.first().account_cr.member.acc_number

        # if queryset.loan is not None:
        #     account_number = queryset.loan.account.acc_number
        # elif queryset.transaction_type == 'Deposit':
        #     account_number = queryset.account_cr.member.acc_number
        # elif queryset.transaction_type == 'Deposit':
        #     account_number = queryset.account_cr.member.acc_number
        return account_number

    def get_account_name(self, obj):
        queryset = Transactions.objects.filter(receipt=obj['receipt'], branch=self.context['branch'])
        account_name = ''
        if queryset.exists():
            account_number = queryset.first().account_cr.member.acc_number
            member_acc = MemberAccount.objects.filter(acc_number=str(account_number))
            if member_acc.exists():
                account_name = member_acc.first().member_names
        return account_name