from django_countries.serializers import CountryFieldMixin
from rest_framework import serializers

from accounts.models import Biodata
from loans.models import Loans
from sacco.models import Member
from transactions.models import Transactions, SharesTransactions


class TransactionsSerializer(serializers.ModelSerializer):
    class Meta:
        model = Transactions
        exclude = ['branch']


class ShareTransSerializer(serializers.ModelSerializer):

    class Meta:
        model = SharesTransactions
        fields = '__all__'

    # def get_branch(self, obj):
    #     branch = SharesTransactions.objects.filter(obj).values_list('user_id', flat=True)
    #
    #     return branch


class LoansSerializer(serializers.ModelSerializer):
    class Meta:
        model = Loans
        fields = '__all__'


class MemberSerializer(serializers.ModelSerializer):

    class Meta:
        model = Member
        exclude = ['biodata']


class BiodataSerializer(CountryFieldMixin, serializers.ModelSerializer):

    class Meta:
        model = Biodata
        fields = '__all__'
