from django.contrib.auth import password_validation
from rest_framework import serializers

from accounts.models import User, Biodata, Business


class UserSerializer(serializers.ModelSerializer):
    class Meta:
        model = User
        extra_kwargs = {'password': {'write_only': True}}
        exclude = ['is_admin', 'is_superuser']


class BusinessSerializer(serializers.ModelSerializer):
    class Meta:
        model = Business
        fields = '__all__'


class BioDataSerializer(serializers.ModelSerializer):
    business = serializers.SerializerMethodField()
    class Meta:
        model = Biodata
        exclude = ('country',)

    def get_business(self, obj):
        queryset = Business.objects.get(id=obj.business.id)
        return BusinessSerializer(queryset).data


class loginSerializer(serializers.Serializer):
    username = serializers.EmailField(max_length=255)
    password = serializers.CharField(max_length=200)

