from django.contrib.auth import views as auth_views
from django.urls import path

from accounts.views import Login, auth_logout, ResetPasswordView, NewUser, BusinessSelectorView

urlpatterns = [
    path('login/', Login.as_view(), name='login'),
    path('logout/', auth_logout, name='logout'),
    path('password-reset/', ResetPasswordView.as_view(), name='forgot_password'),
    path('new-password-staff/', NewUser.as_view(), name='staff_new_password'),
    path('password-reset/done/', auth_views.PasswordResetDoneView.as_view(
        template_name='accounts/password_reset/confirm-mail.html'),
         name='password_reset_done'),
    path('password-reset-confirm/<uidb64>/<token>/',
         auth_views.PasswordResetConfirmView.as_view(
             template_name='accounts/password_reset/set-password.html',
         ),
         name='password_reset_confirm'),
    path('password-reset-complete/',
         auth_views.PasswordResetCompleteView.as_view(
             template_name='accounts/password_reset/reset_complete.html'
         ),
         name='password_reset_complete'),

    path('select-business/',
         BusinessSelectorView.as_view(),
         name="business_selector")
]
