from django.contrib import messages
from django.contrib.auth.mixins import LoginRequiredMixin, UserPassesTestMixin
from django.http import HttpResponseRedirect, HttpResponseForbidden
from django.urls import reverse_lazy

from accounts.models import Permissions


class ViewPermissionsMixin(object):
    """Base class for all custom permission mixins to inherit from"""
    def has_permissions(self):
        return True

    def dispatch(self, request, *args, **kwargs):
        if not self.has_permissions():
            messages.error(request, 'error', extra_tags='Not allowed to view page check your permissions and try again')
            return HttpResponseRedirect(reverse_lazy('index'))
        return super(ViewPermissionsMixin, self).dispatch(request, *args, **kwargs)


class BusinessUserMixin(LoginRequiredMixin, UserPassesTestMixin):
    def __init__(self):
        self.request = None

    def test_func(self):
        if self.request.user.staff and self.request.user.staff.biodata.business is not None:
            return self.request.user.staff

    def handle_no_permission(self):
        return HttpResponseRedirect(reverse_lazy('logout'))


class OnlyNugsoft(LoginRequiredMixin, UserPassesTestMixin):

    def __init__(self):
        self.request = None

    def test_func(self):
        if self.request.user.is_nugsoft:
            return self.request.user.is_nugsoft

    def handle_no_permission(self):
        return HttpResponseRedirect(reverse_lazy('logout'))


class CheckPerm(LoginRequiredMixin, UserPassesTestMixin):

    def __init__(self):
        self.request = None

    def test_func(self):
        # print(perms)
        user_role = self.request.user.staff.position
        perms_in_role = user_role.permissions.all()
        print(perms_in_role)
        if self.request.user.staff:
            return self.request.user.staff

    def handle_no_permission(self):
        return HttpResponseRedirect(reverse_lazy('logout'))



