from django.core.exceptions import PermissionDenied

from accounts.models import Permissions


def user_in_business(function):
    def wrap(request, *args, **kwargs):

        if request.user.staff and request.user.staff.biodata.business is not None:
            return function(request, *args, **kwargs)
        else:
            raise PermissionDenied

    wrap.__doc__ = function.__doc__
    wrap.__name__ = function.__name__
    return wrap


def user_has_perm(permission_name):
    def decorator(view_func):
        def wrapper(request, *args, **kwargs):
            user = request.user
            role = user.staff.position
            permissions = list(role.permissions.all().values_list('description', flat=True))
            if permission_name in permissions:
                print('yeah')
                return view_func(request, *args, **kwargs)
            else:
                print('nope')
                raise PermissionDenied

        return wrapper

    return decorator


