# Generated by Django 4.2.6 on 2023-12-09 13:26

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import django_resized.forms
import utils.file_uploads


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_active', models.BooleanField(default=True, null=True, verbose_name='Active')),
                ('is_admin', models.BooleanField(default=False, null=True, verbose_name='Admin')),
                ('is_superuser', models.BooleanField(default=False, null=True, verbose_name='Super User')),
                ('is_nugsoft', models.BooleanField(default=False, null=True, verbose_name='Nugsoft Admin')),
                ('username', models.CharField(max_length=255, unique=True, verbose_name='Username')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, unique=True)),
            ],
            options={
                'db_table': 'users',
                'ordering': ['-id'],
            },
        ),
        migrations.CreateModel(
            name='Biodata',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('gender', models.CharField(blank=True, choices=[('M', 'Male'), ('F', 'Female')], max_length=1, null=True)),
                ('marital_status', models.IntegerField(blank=True, choices=[(1, 'Single'), (2, 'Married'), (3, 'Divorced'), (4, 'Cohabitation'), (5, 'Widowed')], null=True)),
                ('dob', models.DateField(blank=True, null=True)),
                ('nin', models.CharField(blank=True, max_length=40, null=True)),
                ('contact', models.CharField(blank=True, max_length=40, null=True)),
                ('other_contact', models.CharField(blank=True, max_length=45, null=True)),
                ('mobile_money', models.CharField(blank=True, max_length=40, null=True)),
                ('country', django_countries.fields.CountryField(blank=True, max_length=2, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('nok', models.CharField(blank=True, max_length=255, null=True)),
                ('nok_contacts', models.CharField(blank=True, max_length=20, null=True)),
                ('nok_contacts2', models.CharField(blank=True, max_length=20, null=True)),
                ('photo', models.ImageField(blank=True, null=True, upload_to=utils.file_uploads.bio_photo)),
                ('signature', django_resized.forms.ResizedImageField(blank=True, crop=None, force_format=None, keep_meta=True, null=True, quality=-1, scale=None, size=[100, 100], upload_to=utils.file_uploads.sig_files)),
                ('date_created', models.DateField(auto_now_add=True)),
                ('location', models.TextField(blank=True, null=True)),
                ('employee_no', models.CharField(blank=True, max_length=255, null=True)),
                ('synced', models.BooleanField(default=False, verbose_name='Synced to the portal')),
                ('member_upload', models.UUIDField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'Biodata',
                'verbose_name_plural': 'Biodata',
                'db_table': 'biodata',
            },
        ),
        migrations.CreateModel(
            name='Branch',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.UUIDField(blank=True, null=True, unique=True)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('address', models.TextField(blank=True, null=True)),
                ('contact', models.CharField(blank=True, max_length=20, null=True)),
                ('status', models.IntegerField(blank=True, choices=[(1, 'Active'), (0, 'Suspended'), (2, 'Deactivated')], default=1, null=True)),
                ('date_created', models.DateField(auto_now_add=True)),
                ('is_main', models.BooleanField(default=False)),
                ('synced', models.BooleanField(default=False, verbose_name='Synced to the portal')),
            ],
            options={
                'verbose_name': 'Branch',
                'verbose_name_plural': 'Branches',
                'db_table': 'branches',
            },
        ),
        migrations.CreateModel(
            name='Business',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.UUIDField(blank=True, null=True, unique=True)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('address', models.TextField(blank=True, null=True)),
                ('short_name', models.CharField(blank=True, max_length=100, null=True)),
                ('contact', models.CharField(blank=True, max_length=100, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('logo', models.ImageField(blank=True, null=True, upload_to=utils.file_uploads.logo_files)),
                ('certificate', models.ImageField(blank=True, null=True, upload_to=utils.file_uploads.certificate_files)),
                ('launch_date', models.DateTimeField(blank=True, null=True)),
                ('certificate_no', models.CharField(blank=True, max_length=255, null=True)),
                ('website', models.URLField(blank=True, null=True)),
                ('clients', models.IntegerField(blank=True, default=0, null=True)),
                ('type', models.IntegerField(blank=True, choices=[(1, 'Traditional SACOO'), (2, 'Lending Company'), (3, 'Investment Club'), (4, 'Asset Financing')], null=True)),
                ('status', models.IntegerField(blank=True, choices=[(1, 'Active'), (0, 'Suspended'), (2, 'Deactivated')], default=1, null=True)),
                ('date_created', models.DateField(auto_now_add=True)),
                ('auto_acc_no', models.BooleanField(default=False, verbose_name='Auto generate Account Number')),
                ('does_withdraw', models.BooleanField(default=True, verbose_name='Does withdraw')),
                ('does_deposit', models.BooleanField(default=True, verbose_name='Does deposit')),
                ('does_transfer', models.BooleanField(default=True, verbose_name='Does transfer')),
                ('has_shares', models.BooleanField(default=True, verbose_name='Has shares')),
                ('synced', models.BooleanField(default=False, verbose_name='Synced to the portal')),
                ('business_number', models.CharField(blank=True, max_length=9, null=True, validators=[django.core.validators.MinLengthValidator(9, message='Length has to be 9'), django.core.validators.MaxLengthValidator(9, message='Length has to be 9')])),
            ],
            options={
                'verbose_name': 'Business',
                'verbose_name_plural': 'Businesses',
                'db_table': 'businesses',
            },
        ),
        migrations.CreateModel(
            name='Payroll',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('gross_pay', models.IntegerField(blank=True, default=0, null=True)),
                ('net_pay', models.IntegerField(blank=True, default=0, null=True)),
                ('paye', models.IntegerField(blank=True, default=0, null=True)),
                ('nssf', models.IntegerField(blank=True, default=0, null=True)),
                ('created_date', models.DateField(auto_now_add=True)),
                ('update_on', models.DateTimeField(blank=True, null=True)),
                ('is_deleted', models.BooleanField(default=False)),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.branch')),
            ],
            options={
                'verbose_name': 'payroll',
                'verbose_name_plural': 'payroll',
                'db_table': 'payroll',
            },
        ),
        migrations.CreateModel(
            name='Permissions',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('item_name', models.CharField(blank=True, max_length=255, null=True, unique=True)),
            ],
            options={
                'verbose_name_plural': 'Permissions',
                'db_table': 'permissions',
            },
        ),
        migrations.CreateModel(
            name='Position',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=255)),
                ('created_date', models.DateField(auto_now_add=True)),
                ('update_on', models.DateTimeField(blank=True, null=True)),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.business')),
            ],
            options={
                'verbose_name': 'Position',
                'verbose_name_plural': 'Positions',
                'db_table': 'positions',
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=255)),
                ('created_date', models.DateField(auto_now_add=True)),
                ('business', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='company', to='accounts.business')),
            ],
            options={
                'verbose_name': 'User Role',
                'verbose_name_plural': 'User Roles',
                'db_table': 'user_roles',
            },
        ),
        migrations.CreateModel(
            name='Salutation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'verbose_name': 'Member Salutation',
                'db_table': 'member_salutation',
            },
        ),
        migrations.CreateModel(
            name='SubscriptionPackage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('limit', models.IntegerField(default=0)),
                ('date_created', models.DateField(auto_now_add=True)),
                ('status', models.BooleanField(default=True)),
            ],
            options={
                'verbose_name': 'Subscription Package',
                'verbose_name_plural': 'Subscription Packages',
                'db_table': 'subscription_packages',
            },
        ),
        migrations.CreateModel(
            name='Staff',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('on_payroll', models.BooleanField(default=False)),
                ('is_active', models.BooleanField(default=True)),
                ('is_contact', models.BooleanField(default=False, verbose_name='Is this staff a contact person?')),
                ('biodata', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.biodata')),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='office', to='accounts.branch')),
                ('position', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='positions', to='accounts.position')),
                ('role', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='roles', to='accounts.role')),
            ],
            options={
                'verbose_name': 'Staff',
                'verbose_name_plural': 'Staffs',
                'db_table': 'staffs',
            },
        ),
        migrations.AddField(
            model_name='role',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='staffs', to='accounts.staff'),
        ),
        migrations.AddField(
            model_name='position',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='admin', to='accounts.staff'),
        ),
        migrations.AddField(
            model_name='position',
            name='permissions',
            field=models.ManyToManyField(blank=True, to='accounts.permissions'),
        ),
        migrations.CreateModel(
            name='PayrollPayment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('gross_pay', models.FloatField(blank=True, default=0, null=True)),
                ('net_pay', models.FloatField(blank=True, default=0, null=True)),
                ('paye', models.FloatField(blank=True, default=0, null=True)),
                ('nssf', models.FloatField(blank=True, default=0, null=True)),
                ('month', models.DateField(null=True)),
                ('type', models.IntegerField(choices=[(1, 'Salary'), (2, 'Allowance'), (3, 'Advance')], default=1)),
                ('created_date', models.DateField(auto_now_add=True)),
                ('update_on', models.DateTimeField(blank=True, null=True)),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.branch')),
                ('payroll', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounts.payroll')),
            ],
            options={
                'verbose_name': 'payroll_payment',
                'verbose_name_plural': 'payroll_payments',
                'db_table': 'payroll_payments',
            },
        ),
        migrations.AddField(
            model_name='payroll',
            name='staff',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='staff', to='accounts.staff'),
        ),
        migrations.CreateModel(
            name='EmailResetCode',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinLengthValidator(6, message='Length has to be 6'), django.core.validators.MaxLengthValidator(6, message='Length has to be 6')])),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'email_reset_code',
            },
        ),
        migrations.AddField(
            model_name='business',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='accounts.staff'),
        ),
        migrations.AddField(
            model_name='business',
            name='package',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.subscriptionpackage'),
        ),
        migrations.AddField(
            model_name='branch',
            name='business',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='branches', to='accounts.business'),
        ),
        migrations.AddField(
            model_name='branch',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='creator', to='accounts.staff'),
        ),
        migrations.AddField(
            model_name='biodata',
            name='business',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.business'),
        ),
        migrations.AddField(
            model_name='biodata',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='created', to='accounts.staff'),
        ),
        migrations.AddField(
            model_name='biodata',
            name='title',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.salutation'),
        ),
        migrations.AddField(
            model_name='user',
            name='staff',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='accounts.staff'),
        ),
    ]
